/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWWorkflowClassTreeNode;
import filenet.vw.toolkit.design.property.workflow.VWWorkflowHierarchyTreeRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VWSelectBaseWorkflowDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener,
TreeSelectionListener,
TreeExpansionListener {
    private JTree m_workClassTree = null;
    private DefaultTreeModel m_treeModel = null;
    private JTextField m_workClassNameTextField = null;
    private JTextField m_workClassSubjectTextField = null;
    private JTextArea m_workClassDescriptionTextArea = null;
    private JSplitPane m_splitPane = null;
    private VWDialogButtons m_dialogButtons = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private int m_result = 2;
    private boolean m_bFirstTime = true;
    private boolean m_bBrowseOnly = false;

    public VWSelectBaseWorkflowDialog(VWAuthPropertyData authPropertyData, String baseWorkClassName) {
        this(authPropertyData, baseWorkClassName, false);
    }

    public VWSelectBaseWorkflowDialog(VWAuthPropertyData authPropertyData, String workClassName, boolean bBrowseOnly) {
        super(authPropertyData.getMainContainer());
        this.m_authPropertyData = authPropertyData;
        this.m_bBrowseOnly = bBrowseOnly;
        this.initializeLayout();
        this.selectBaseWorkClassNode(workClassName);
    }

    public int getResult() {
        return this.m_result;
    }

    public String getBaseWorkflowClassName() {
        return this.m_workClassNameTextField.getText();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_splitPane != null) {
                this.m_splitPane.setDividerLocation(0.5);
            }
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: 
            case 4: {
                this.performOKAction();
                break;
            }
            case 2: {
                this.performCancelAction();
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        try {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            if (node instanceof VWWorkflowClassTreeNode) {
                this.performNodeSelectionAction((VWWorkflowClassTreeNode)node);
            } else {
                this.performNodeSelectionAction(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        try {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            if (node instanceof VWWorkflowClassTreeNode) {
                this.performNodeExpansionAction((VWWorkflowClassTreeNode)node);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private void initializeLayout() {
        this.setTitle(VWResource.s_selectBaseWorkflow);
        Dimension dim = VWStringUtils.stringToDimension("665,335");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(600, 350);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.m_splitPane = new JSplitPane(1, this.getTreePanel(), this.getPropertiesPanel());
        this.getContentPane().add((Component)this.m_splitPane, "Center");
        this.m_dialogButtons = new VWDialogButtons(this.m_bBrowseOnly ? 36 : 35);
        this.m_dialogButtons.setButtonEnabled(1, false);
        this.m_dialogButtons.addDialogButtonsActionListener(this);
        this.getContentPane().add((Component)this.m_dialogButtons, "Last");
    }

    private JPanel getTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            String routerName = VWResource.s_processEngine;
            if (this.m_authPropertyData.getVWSession() != null) {
                routerName = this.m_authPropertyData.getVWSession().getConnectionPointName();
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(routerName);
            this.m_treeModel = new DefaultTreeModel(root);
            VWWorkflowSignature workflowSignature = VWClassFactory.VWWorkflowDefinition_fetchWorkflowSignature("WorkObjectEx", this.m_authPropertyData.getSessionInfo().getSession(), this.m_authPropertyData.getWorkflowDefinition(), 234L);
            VWWorkflowClassTreeNode wobNode = new VWWorkflowClassTreeNode(workflowSignature);
            if (wobNode != null) {
                this.m_treeModel.insertNodeInto(wobNode, root, 0);
            }
            this.m_workClassTree = new JTree(this.m_treeModel);
            this.m_workClassTree.setName("m_workClassTree_VWSelectBaseWorkflowDialog");
            this.m_workClassTree.setCellRenderer(new VWWorkflowHierarchyTreeRenderer());
            this.m_workClassTree.addTreeSelectionListener(this);
            this.m_workClassTree.addTreeExpansionListener(this);
            this.m_workClassTree.getSelectionModel().setSelectionMode(1);
            panel.add((Component)new JScrollPane(this.m_workClassTree), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel getPropertiesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        try {
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_nameStr);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_workClassNameTextField = new JTextField();
            this.m_workClassNameTextField.setName("m_workClassNameTextField_VWSelectBaseWorkflowDialog");
            this.m_workClassNameTextField.setEditable(false);
            clientPanel.add(this.m_workClassNameTextField);
            panel.add((Component)toolbarBorder, gbCons);
            ++gbCons.gridy;
            toolbarBorder = new VWToolbarBorder(VWResource.s_subjectStr);
            clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_workClassSubjectTextField = new JTextField();
            this.m_workClassSubjectTextField.setName("m_workClassSubjectTextField_VWSelectBaseWorkflowDialog");
            this.m_workClassSubjectTextField.setEditable(false);
            clientPanel.add(this.m_workClassSubjectTextField);
            panel.add((Component)toolbarBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            toolbarBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_workClassDescriptionTextArea = new JTextArea();
            this.m_workClassDescriptionTextArea.setName("m_workClassDescriptionTextArea_VWSelectBaseWorkflowDialog");
            this.m_workClassDescriptionTextArea.setEditable(false);
            clientPanel.add(new JScrollPane(this.m_workClassDescriptionTextArea));
            panel.add((Component)toolbarBorder, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void selectBaseWorkClassNode(String baseWorkClassName) {
        if (this.m_workClassTree == null) {
            return;
        }
        try {
            TreePath treePath = null;
            if (VWStringUtils.compare(baseWorkClassName, "WorkObjectEx") == 0) {
                Object root = this.m_treeModel.getRoot();
                if (root != null && this.m_treeModel.getChildCount(root) > 0) {
                    Object node = this.m_treeModel.getChild(root, 0);
                    Object[] nodes = this.m_treeModel.getPathToRoot((TreeNode)node);
                    treePath = new TreePath(nodes);
                }
            } else {
                ArrayList<VWWorkflowSignature> parentList = VWClassFactory.VWWorkflowDefinition_fetchParentWorkflowSignatures(baseWorkClassName, this.m_authPropertyData.getVWSession(), this.m_authPropertyData.getWorkflowDefinition(), 234L);
                if (parentList != null && parentList.size() > 0) {
                    ArrayList<VWWorkflowClassTreeNode> parentNodes = new ArrayList<VWWorkflowClassTreeNode>();
                    VWWorkflowClassTreeNode grandParentNode = null;
                    VWWorkflowClassTreeNode parentNode = null;
                    VWWorkflowClassTreeNode[] childNodes = null;
                    for (int i = parentList.size() - 1; i >= 0; --i) {
                        VWWorkflowSignature parentWflSignature = parentList.get(i);
                        parentNode = null;
                        if (VWStringUtils.compare(parentWflSignature.getName(), "WorkObjectEx") == 0) {
                            parentNode = (VWWorkflowClassTreeNode)this.m_treeModel.getChild(this.m_treeModel.getRoot(), 0);
                        } else {
                            if (childNodes != null) {
                                for (int j = 0; j < childNodes.length; ++j) {
                                    if (VWStringUtils.compare(childNodes[j].getName(), parentWflSignature.getName()) != 0) continue;
                                    parentNode = childNodes[j];
                                    break;
                                }
                            }
                            if (parentNode == null && grandParentNode != null) {
                                parentNode = new VWWorkflowClassTreeNode(parentWflSignature);
                                this.m_treeModel.insertNodeInto(parentNode, grandParentNode, grandParentNode.getChildCount());
                            }
                        }
                        if (parentNode == null) continue;
                        parentNodes.add(parentNode);
                        childNodes = this.performNodeExpansionAction(parentNode);
                        grandParentNode = parentNode;
                    }
                    if (parentNodes.size() > 0) {
                        VWWorkflowClassTreeNode[] nodeParents = parentNodes.toArray(new VWWorkflowClassTreeNode[0]);
                        Object[] td = this.m_treeModel.getPathToRoot(nodeParents[parentNodes.size() - 1]);
                        treePath = new TreePath(td);
                    }
                }
            }
            this.m_workClassTree.expandPath(treePath);
            this.m_workClassTree.makeVisible(treePath);
            this.m_workClassTree.setSelectionPath(treePath);
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void performOKAction() {
        this.m_result = 1;
        this.setVisible(false);
    }

    private void performCancelAction() {
        this.m_result = 2;
        this.setVisible(false);
    }

    private void performHelpAction() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh046.htm");
    }

    private void performNodeSelectionAction(VWWorkflowClassTreeNode wflClassNode) {
        if (wflClassNode != null) {
            this.m_workClassNameTextField.setText(wflClassNode.getName());
            this.m_workClassSubjectTextField.setText(wflClassNode.getSubject());
            this.m_workClassDescriptionTextArea.setText(wflClassNode.getDescription());
            if (wflClassNode.getName() != null) {
                this.m_dialogButtons.setButtonEnabled(1, true);
            } else {
                this.m_dialogButtons.setButtonEnabled(1, false);
            }
        } else {
            this.m_workClassNameTextField.setText(null);
            this.m_workClassSubjectTextField.setText(null);
            this.m_workClassDescriptionTextArea.setText(null);
            this.m_dialogButtons.setButtonEnabled(1, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VWWorkflowClassTreeNode[] performNodeExpansionAction(VWWorkflowClassTreeNode parentNode) {
        VWWorkflowClassTreeNode[] nodes = null;
        ArrayList<VWWorkflowClassTreeNode> nodeList = new ArrayList<VWWorkflowClassTreeNode>();
        try {
            block10: {
                try {
                    VWWorkflowDefinition[] wflDefs;
                    if (parentNode == null || parentNode.getHasRetrievedChildren()) break block10;
                    this.m_authPropertyData.displayWaitCursor(this.getRootPane());
                    parentNode.removeAllChildren();
                    HashSet<Object> uniqueNameList = new HashSet();
                    String parentNodeName = parentNode.getName();
                    Object[] inheritedWorkflowClassNames = this.m_authPropertyData.getVWSession().fetchWorkClassNames(false, parentNodeName);
                    if (inheritedWorkflowClassNames != null && inheritedWorkflowClassNames.length > 0) {
                        uniqueNameList = new HashSet<String>(Arrays.asList(inheritedWorkflowClassNames));
                    }
                    if ((wflDefs = VWClassFactory.VWWorkflowCollectionDefinition_getWorkflows(this.m_authPropertyData.getWorkflowCollectionDefinition(), true, 234L)) != null) {
                        for (int i = 0; i < wflDefs.length; ++i) {
                            if (VWStringUtils.compare(parentNodeName, wflDefs[i].getBaseWorkClassName()) != 0) continue;
                            uniqueNameList.add(wflDefs[i].getName());
                        }
                    }
                    inheritedWorkflowClassNames = uniqueNameList.toArray(new String[0]);
                    VWSession vwSession = this.m_authPropertyData.getSessionInfo().getSession();
                    VWWorkflowDefinition wflDef = this.m_authPropertyData.getWorkflowDefinition();
                    if (inheritedWorkflowClassNames != null && inheritedWorkflowClassNames.length > 0) {
                        VWQubbleSort.sort(inheritedWorkflowClassNames);
                        for (int i = 0; i < inheritedWorkflowClassNames.length; ++i) {
                            VWWorkflowSignature workflowSignature = VWClassFactory.VWWorkflowDefinition_fetchWorkflowSignature((String)inheritedWorkflowClassNames[i], vwSession, wflDef, 234L);
                            VWWorkflowClassTreeNode childNode = new VWWorkflowClassTreeNode(workflowSignature);
                            if (childNode == null || VWStringUtils.compare(parentNodeName, childNode.getBaseWorkClassName()) != 0) continue;
                            nodeList.add(childNode);
                            this.m_treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                        }
                    }
                    parentNode.setHasRetrievedChildren();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var14_16 = null;
                    this.m_treeModel.nodeStructureChanged(parentNode);
                    this.m_authPropertyData.restoreDefaultCursor(this.getRootPane());
                }
            }
            Object var14_15 = null;
            this.m_treeModel.nodeStructureChanged(parentNode);
            this.m_authPropertyData.restoreDefaultCursor(this.getRootPane());
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.m_treeModel.nodeStructureChanged(parentNode);
            this.m_authPropertyData.restoreDefaultCursor(this.getRootPane());
            throw throwable;
        }
        if (nodeList.size() > 0) {
            nodes = nodeList.toArray(new VWWorkflowClassTreeNode[0]);
        }
        return nodes;
    }
}

